(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36391,       1211]
NotebookOptionsPosition[     33151,       1099]
NotebookOutlinePosition[     34539,       1147]
CellTagsIndexPosition[     34496,       1144]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Pavages du plan", "Title",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[TextData[{
 "Il existe partout des dessins obtenus par r\[EAcute]p\[EAcute]titions d'un \
motif unique: carreaux d'une fen\[EHat]tre, tuiles d'une toiture, lattes de \
bois d'une cl\[OHat]ture, briques d'un mur, papier peint, tissu,... On ne les \
trouve pas seulement dans des objets produits par l'homme: le rayon de cire \
d'abeille, la corolle des fleurs, le cristal de sel,...\nLa couverture d'un \
plan par r\[EAcute]p\[EAcute]titions d'un m\[EHat]me motif, sans \
chevauchements ni trous, s'appelle un ",
 StyleBox["pavage",
  FontWeight->"Bold"],
 ". Comme c'est le cas pour toutes les t\[AHat]ches \
r\[EAcute]p\[EAcute]titives, l'informatique s'av\[EGrave]re tr\[EGrave]s \
utile pour produire des pavages."
}], "Text",
 Evaluatable->False,
 PageBreakAbove->False,
 TextAlignment->Left,
 TextJustification->0,
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["D\[EAcute]finition du motif", "Subsubtitle"],

Cell[TextData[{
 "Pour d\[EAcute]finir une forme, on proc\[EGrave]de comme ci-dessous. On \
donne un nom sans espaces ou symboles ayant une signification \
sp\[EAcute]ciale dans ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (comme - par exemple). Vient ensuite le signe =. Enfin, entre accolades, \
on indique la couleur, puis, apr\[EGrave]s une virgule, viennent la ou les \
primitives graphiques."
}], "Text",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"carr\[EAcute]", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"croix", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "1", ",", "0"}], "]"}], ",", 
     RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0.5"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "}"}], "]"}]}], 
    "}"}]}], ";"}]}], "Input",
 AspectRatioFixed->True],

Cell["\<\
Une fois toutes les parties du dessin d\[EAcute]finies, on indique l'ordre \
dans lequel elles doivent \[EHat]tre dessin\[EAcute]es:\
\>", "Text",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"pav\[EAcute]", "=", 
   RowBox[{"{", 
    RowBox[{"carr\[EAcute]", ",", "croix"}], "}"}]}], ";"}]], "Input",
 AspectRatioFixed->True],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " dessinera d'abord le carr\[EAcute] puis la croix. Changez l'ordre pour \
voir la diff\[EAcute]rence ! \nRien ne sera dessin\[EAcute] \[AGrave] l'\
\[EAcute]cran tant que vous ne direz pas \[AGrave] ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " de le faire ! Voici l'instruction \[AGrave] utiliser:"
}], "Text",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", "pav\[EAcute]", "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 AspectRatioFixed->True],

Cell["\<\
(on peut r\[EAcute]duire ou agrandir de dessin en cliquant dessus et en \
manipulant les poign\[EAcute]es).\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["R\[EAcute]p\[EAcute]tition du motif", "Subsubtitle"],

Cell[TextData[{
 "Le motif g\[EAcute]n\[EAcute]rique de pavage sera d\[EAcute]fini comme \
suit. On doit d'abord donner les deux directions de translation (pour couvrir \
un plan il faut deux directions). On peut faire une analogie avec les \
machines \[AGrave] \[EAcute]crire. En tapant sur une touche, la touche \
\"avance\" automatiquement d'un cran vers la droite; cela correspond pour \
nous \[AGrave] notre direction ",
 StyleBox["u",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 ". \[CapitalAGrave] la fin d'une ligne, on descend d'un cran avant de \
recommencer une nouvelle ligne; c'est notre direction ",
 StyleBox["v",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 ". Remarquez que les vecteurs ",
 StyleBox["u",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " et ",
 StyleBox["v",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " n'ont pas besoin d'\[EHat]tre perpendiculaires; ils doivent seulement \
\[EHat]tre non colin\[EAcute]aires."
}], "Text",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[TextData[{
 "Comme notre dessin a une largeur de 2, on se d\[EAcute]calera de deux unit\
\[EAcute]s vers la droite (",
 StyleBox["u",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 "). Comme on a envie que nos dessins soient r\[EAcute]p\[EAcute]t\[EAcute]s \
en quinconce, la direction ",
 StyleBox["v",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " indique que pour recommencer une ligne, on se d\[EAcute]calera d'un cran \
vers la droite et de deux vers le haut par rapport \[AGrave] la ligne pr\
\[EAcute]c\[EAcute]dente."
}], "Text",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}], ";", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], ";"}]], "Input",
 AspectRatioFixed->True],

Cell["\<\
On d\[EAcute]finit maintenant le motif g\[EAcute]n\[EAcute]rique qui \
permettra de paver notre plan:\
\>", "Text",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"motif", "=", 
   RowBox[{"ReplaceAll", "[", 
    RowBox[{"pav\[EAcute]", ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x_", "?", "NumberQ"}], ",", 
        RowBox[{"y_", "?", "NumberQ"}]}], "}"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{
          RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           " ", "dx"}], "+", 
         RowBox[{
          RowBox[{"v", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           " ", "dy"}]}], ",", 
        RowBox[{"y", "+", 
         RowBox[{
          RowBox[{"u", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           " ", "dx"}], "+", 
         RowBox[{
          RowBox[{"v", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           " ", "dy"}]}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 AspectRatioFixed->True],

Cell[TextData[{
 "La fonction ",
 StyleBox["ReplaceAll",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " remplace les coordonn\[EAcute]es ",
 StyleBox["x",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " par ",
 StyleBox["x+u[[1]]dx+v[[1]]dy",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " et les coordonn\[EAcute]es ",
 StyleBox["y",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " par ",
 StyleBox["y+u[[2]]dx+v[[2]]dy",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 ". On peut maintenant cr\[EAcute]er une liste en faisant varier ",
 StyleBox["dx",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " et ",
 StyleBox["dy",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " entre 0 et le nombre de r\[EAcute]p\[EAcute]titions moins une que l'on \
veut en horizontal et en vertical. Dans notre exemple, on a d\[EAcute]cid\
\[EAcute] de r\[EAcute]p\[EAcute]ter 5 fois selon la direction ",
 StyleBox["u",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " et 4 fois selon la direction ",
 StyleBox["v",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 ":"
}], "Text",
 PageWidth->WindowWidth,
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"pavage", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"motif", ",", 
     RowBox[{"{", 
      RowBox[{"dx", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dy", ",", "0", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Input",
 AspectRatioFixed->True],

Cell["Dessinons enfin ce pavage :", "Text",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", "pavage", "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 AspectRatioFixed->True],

Cell["\<\
Vous trouverez ci-dessous trois pavages de difficult\[EAcute]s croissantes.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Exemple 1 : le carrelage", "Subsection",
 Evaluatable->False,
 PageBreakAbove->True,
 AspectRatioFixed->True],

Cell["\<\
D'apr\[EGrave]s le travail de Pauline Bart, classe 1BD', mars 1997.\
\>", "Text",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fond", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"0", ",", "0.8`", ",", "0.8`"}], "]"}], ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"carr\[EAcute]", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "0.5`", ",", "0"}], "]"}], ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"triangleGauche", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.1`", ",", "0.1`", ",", "0.7`"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"triangleHaut", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.1`", ",", "0.1`", ",", "0.7`"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"triangleDroit", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.1`", ",", "0.1`", ",", "0.7`"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"triangleBas", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"0.1`", ",", "0.1`", ",", "0.7`"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"planelle", "=", 
   RowBox[{"{", 
    RowBox[{
    "fond", ",", "carr\[EAcute]", ",", "triangleGauche", ",", "triangleHaut", 
     ",", "triangleDroit", ",", "triangleBas"}], "}"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", "planelle", "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], "Input",
 AspectRatioFixed->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}]}], ";", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"motif", "=", 
   RowBox[{"planelle", "/.", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x_", "?", "NumberQ"}], ",", 
       RowBox[{"y_", "?", "NumberQ"}]}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{
         RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
         " ", "dx"}], "+", 
        RowBox[{
         RowBox[{"v", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
         " ", "dy"}]}], ",", 
       RowBox[{"y", "+", 
        RowBox[{
         RowBox[{"u", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
         " ", "dx"}], "+", 
        RowBox[{
         RowBox[{"v", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
         " ", "dy"}]}]}], "}"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pavage", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"motif", ",", 
     RowBox[{"{", 
      RowBox[{"dx", ",", "0", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dy", ",", "0", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", "pavage", "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], "Input",
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exemple 2 : le troupeau d'\[EAcute]l\[EAcute]phants\
\>", "Subsection",
 Evaluatable->False,
 PageBreakAbove->True,
 AspectRatioFixed->True],

Cell["\<\
D'apr\[EGrave]s le travail de Fr\[EAcute]d\[EAcute]ric Girardin, classe 1C, \
mars 1997.\
\>", "Text",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"s1", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]}], ";", 
   RowBox[{"s2", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4"}], "}"}]}], ";", 
   RowBox[{"s3", "=", 
    RowBox[{"{", 
     RowBox[{"2", ",", "6"}], "}"}]}], ";", 
   RowBox[{"s4", "=", 
    RowBox[{"{", 
     RowBox[{"2", ",", "7"}], "}"}]}], ";", 
   RowBox[{"s5", "=", 
    RowBox[{"{", 
     RowBox[{"3", ",", "7"}], "}"}]}], ";"}], ",", 
  RowBox[{
   RowBox[{"s6", "=", 
    RowBox[{"{", 
     RowBox[{"4", ",", "9"}], "}"}]}], ";", 
   RowBox[{"s7", "=", 
    RowBox[{"{", 
     RowBox[{"5", ",", "9"}], "}"}]}], ";", 
   RowBox[{"s8", "=", 
    RowBox[{"{", 
     RowBox[{"6", ",", "8"}], "}"}]}], ";", 
   RowBox[{"s9", "=", 
    RowBox[{"{", 
     RowBox[{"9", ",", "8"}], "}"}]}], ";", 
   RowBox[{"s10", "=", 
    RowBox[{"{", 
     RowBox[{"11", ",", "7"}], "}"}]}], ";"}], ",", 
  RowBox[{
   RowBox[{"s11", "=", 
    RowBox[{"{", 
     RowBox[{"12", ",", "6"}], "}"}]}], ";", 
   RowBox[{"s12", "=", 
    RowBox[{"{", 
     RowBox[{"12", ",", "5"}], "}"}]}], ";", 
   RowBox[{"s13", "=", 
    RowBox[{"{", 
     RowBox[{"14", ",", "3"}], "}"}]}], ";", 
   RowBox[{"s14", "=", 
    RowBox[{"{", 
     RowBox[{"11", ",", "3"}], "}"}]}], ";", 
   RowBox[{"s15", "=", 
    RowBox[{"{", 
     RowBox[{"12", ",", "0"}], "}"}]}], ";", 
   RowBox[{"s16", "=", 
    RowBox[{"{", 
     RowBox[{"11", ",", "0"}], "}"}]}], ";", 
   RowBox[{"s17", "=", 
    RowBox[{"{", 
     RowBox[{"10", ",", "2"}], "}"}]}], ";", 
   RowBox[{"s18", "=", 
    RowBox[{"{", 
     RowBox[{"10", ",", "0"}], "}"}]}], ";"}], ",", 
  RowBox[{
   RowBox[{"s19", "=", 
    RowBox[{"{", 
     RowBox[{"9", ",", "2"}], "}"}]}], ";", 
   RowBox[{"s20", "=", 
    RowBox[{"{", 
     RowBox[{"6", ",", "3"}], "}"}]}], ";", 
   RowBox[{"s21", "=", 
    RowBox[{"{", 
     RowBox[{"7", ",", "0"}], "}"}]}], ";", 
   RowBox[{"s22", "=", 
    RowBox[{"{", 
     RowBox[{"6", ",", "0"}], "}"}]}], ";", 
   RowBox[{"s23", "=", 
    RowBox[{"{", 
     RowBox[{"5", ",", "0"}], "}"}]}], ";"}], ",", 
  RowBox[{
   RowBox[{"s24", "=", 
    RowBox[{"{", 
     RowBox[{"5", ",", "4"}], "}"}]}], ";", 
   RowBox[{"s25", "=", 
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}]}], ";", 
   RowBox[{"s26", "=", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}]}], ";", 
   RowBox[{"s27", "=", 
    RowBox[{"{", 
     RowBox[{"4", ",", "8"}], "}"}]}], ";"}], ",", 
  RowBox[{
   RowBox[{"s28", "=", 
    RowBox[{"{", 
     RowBox[{"5", ",", "8"}], "}"}]}], ";", 
   RowBox[{"s29", "=", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}]}], ";", 
   RowBox[{"s30", "=", 
    RowBox[{"{", 
     RowBox[{"4", ",", "6"}], "}"}]}], ";", 
   RowBox[{"s31", "=", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], ";"}], ",", 
  RowBox[{
   RowBox[{"corps", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0.5`", "]"}], ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
        "s8", ",", "s9", ",", "s10", ",", "s11", ",", "s12", ",", "s14", ",", 
         "s15", ",", "s16", ",", "s17", ",", "s19", ",", "s20", ",", "s22", 
         ",", "s23", ",", "s24", ",", "s25"}], "}"}], "]"}]}], "}"}]}], ";"}],
   ",", 
  RowBox[{
   RowBox[{"oreille", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0.4`", "]"}], ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
        "s24", ",", "s25", ",", "s8", ",", "s27", ",", "s26", ",", "s24"}], 
        "}"}], "]"}]}], "}"}]}], ";"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"t\[EHat]te", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0.45`", "]"}], ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
        "s1", ",", "s2", ",", "s3", ",", "s4", ",", "s6", ",", "s7", ",", 
         "s8", ",", "s27", ",", "s26", ",", "s29", ",", "s1"}], "}"}], 
       "]"}]}], "}"}]}], ";"}], ",", 
  RowBox[{
   RowBox[{"patteAvant", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"GrayLevel", "[", "0.3`", "]"}], ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{"s20", ",", "s21", ",", "s22", ",", "s20"}], "}"}], "]"}]}], 
     "}"}]}], ";"}]}], "\n", 
 RowBox[{
  RowBox[{"patteArri\[EGrave]re", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", "0.3`", "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{"s18", ",", "s17", ",", "s16", ",", "s18"}], "}"}], "]"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"queue", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", "0.2`", "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{"s12", ",", "s13", ",", "s11", ",", "s12"}], "}"}], "]"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"d\[EAcute]fense", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CMYKColor", "[", 
      RowBox[{"0", ",", "0", ",", "0.2`", ",", "0"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{"s30", ",", "s31", ",", "s26", ",", "s30"}], "}"}], "]"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"oeil", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "7"}], "}"}], ",", "0.2`"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"sol", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CMYKColor", "[", 
      RowBox[{"0.1`", ",", "0.2`", ",", "0.4`", ",", "0"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "9"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"16", ",", "9"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"14", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"\[EAcute]l\[EAcute]phant", "=", 
   RowBox[{"{", 
    RowBox[{
    "sol", ",", "corps", ",", "oreille", ",", "t\[EHat]te", ",", "patteAvant",
      ",", "patteArri\[EGrave]re", ",", "queue", ",", "d\[EAcute]fense", ",", 
     "oeil"}], "}"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", "\[EAcute]l\[EAcute]phant", "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], "Input",
 AspectRatioFixed->True],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"14", ",", "0"}], "}"}]}], ";", 
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "9"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"motif", "=", 
   RowBox[{"\[EAcute]l\[EAcute]phant", "/.", "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x_", "?", "NumberQ"}], ",", 
       RowBox[{"y_", "?", "NumberQ"}]}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{
         RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
         " ", "dx"}], "+", 
        RowBox[{
         RowBox[{"v", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
         " ", "dy"}]}], ",", 
       RowBox[{"y", "+", 
        RowBox[{
         RowBox[{"u", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
         " ", "dx"}], "+", 
        RowBox[{
         RowBox[{"v", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
         " ", "dy"}]}]}], "}"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pavage", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"motif", ",", 
     RowBox[{"{", 
      RowBox[{"dx", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dy", ",", "0", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", "pavage", "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], "Input",
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exemple 3 : enchev\[EHat]trement", "Subsection"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bout1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CMYKColor", "[", 
      RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"bord1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"bout2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CMYKColor", "[", 
      RowBox[{"1", ",", "0.2`", ",", "0", ",", "0"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.5`", ",", "1.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.5`", ",", "1.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5`", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"bord2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3.5`"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "2.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.5`", ",", "1.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.5`", ",", "1.5`"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5`", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"bout3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CMYKColor", "[", 
      RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"bord3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "4"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"bout4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CMYKColor", "[", 
      RowBox[{"0", ",", "0.2`", ",", "1", ",", "0"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3.5`", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4.5`", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "0.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4.5`", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.5`", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "0.5`"}], "}"}]}], "}"}], "]"}]}], "}"}]}], ";", 
  RowBox[{"bord4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4.5`", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "0.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4.5`", ",", "5"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3.5`", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "0.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.5`", ",", "5"}], "}"}]}], "}"}], "]"}]}], "}"}]}], ";", 
  RowBox[{"bout5", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"CMYKColor", "[", 
      RowBox[{"1", ",", "0.2`", ",", "0", ",", "0"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "3.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.5`", ",", "1.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"bord5", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "3.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2.5`", ",", "1.5`"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2.5`"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"pav\[EAcute]", "=", 
   RowBox[{"{", 
    RowBox[{
    "bout1", ",", "bord1", ",", "bout2", ",", "bord2", ",", "bout3", ",", 
     "bord3", ",", "bout4", ",", "bord4", ",", "bout5", ",", "bord5"}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", "pav\[EAcute]", "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"u", "=", 
    RowBox[{"{", 
     RowBox[{"5", ",", "0"}], "}"}]}], ";", 
   RowBox[{"v", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}], ";"}], ",", 
  RowBox[{
   RowBox[{"motif", "=", 
    RowBox[{"pav\[EAcute]", "/.", "\[InvisibleSpace]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x_", "?", "NumberQ"}], ",", 
        RowBox[{"y_", "?", "NumberQ"}]}], "}"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{
          RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           " ", "dx"}], "+", 
         RowBox[{
          RowBox[{"v", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           " ", "dy"}]}], ",", 
        RowBox[{"y", "+", 
         RowBox[{
          RowBox[{"u", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           " ", "dx"}], "+", 
         RowBox[{
          RowBox[{"v", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           " ", "dy"}]}]}], "}"}]}]}]}], ";"}], ",", 
  RowBox[{
   RowBox[{"pavage", "=", 
    RowBox[{"Table", "[", 
     RowBox[{"motif", ",", 
      RowBox[{"{", 
       RowBox[{"dx", ",", "0", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"dy", ",", "0", ",", "4"}], "}"}]}], "]"}]}], ";"}]}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", "pavage", "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], "Input",
 AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercice", "Section",
 Evaluatable->False,
 AspectRatioFixed->True],

Cell[TextData[{
 "R\[EAcute]alisez votre pavage en couleurs en vous inspirant des exemples 1 \
et 2.\n1. Sur une feuille de papier quadrill\[EAcute]e munie d'un \
rep\[EGrave]re cart\[EAcute]sien, dessinez un motif de votre choix.\n2. D\
\[EAcute]composez votre motif en sous-motifs et approchez ces formes par des \
polygones, des disques et des traits.\n3. Entrez les sous-motifs comme indiqu\
\[EAcute] dans les exemples en faisant attention \[AGrave] l'ordre.\n4. V\
\[EAcute]rifiez gr\[AHat]ce \[AGrave] la fonction ",
 StyleBox["Show",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " que le dessin entr\[EAcute] correspond bien \[AGrave] ce que vous \
attendiez.\n5. D\[EAcute]finissez les directions de translation ",
 StyleBox["u",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " et ",
 StyleBox["v",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " qui permettront de construire le pavage.\n6. Entrez la d\[EAcute]finition \
de ",
 StyleBox["motif",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " (copy/paste en utilisant le nom de votre dessin).\n7. Entrez la \
d\[EAcute]finition de la fonction ",
 StyleBox["pavage",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 " et visualisez votre pavage gr\[AHat]ce \[AGrave] la fonction ",
 StyleBox["Show",
  FontFamily->"Courier",
  FontWeight->"Bold"],
 "."
}], "Text",
 Evaluatable->False,
 AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"EditBar",
CellGrouping->Automatic,
WindowSize->{639, 562},
WindowMargins->{{182, Automatic}, {Automatic, -17}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"], Inherited, 
   Cell[
    TextData[{
      ValueBox["FileName"]}], "Header"]}, {
   Cell[
    TextData[{
      ValueBox["FileName"]}], "Header"], Inherited, 
   Cell[
    TextData[{
      CounterBox["Page"]}], "PageNumber"]}},
PrintingOptions->{"FacingPages"->True,
"FirstPageHeader"->False,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{54, 54}, {72, 72}}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
MacintoshSystemPageSetup -> \
"00<0004/0B`000003;H8`_mooh/=<`Tj0fL5N`?P0080004/0B`000000c82>001\n\
0000I00000000`<30?l00BL?00400@:MkX`000000000LV0801T1T000000@0000\n\
00000000004000:N6D@0000000800000",
CharacterEncoding->"MacintoshAutomaticEncoding",
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 78, 2, 83, "Title",
 Evaluatable->False],
Cell[671, 27, 849, 18, 119, "Text",
 Evaluatable->False,
 PageBreakAbove->False],
Cell[CellGroupData[{
Cell[1545, 49, 50, 0, 28, "Subsubtitle"],
Cell[1598, 51, 466, 11, 65, "Text",
 Evaluatable->False],
Cell[2067, 64, 1465, 49, 72, "Input"],
Cell[3535, 115, 202, 5, 29, "Text",
 Evaluatable->False],
Cell[3740, 122, 168, 5, 31, "Input"],
Cell[3911, 129, 433, 11, 65, "Text",
 Evaluatable->False],
Cell[4347, 142, 200, 5, 31, "Input"],
Cell[4550, 149, 131, 3, 29, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4718, 157, 58, 0, 28, "Subsubtitle"],
Cell[4779, 159, 1020, 27, 121, "Text",
 Evaluatable->False],
Cell[5802, 188, 595, 16, 67, "Text",
 Evaluatable->False],
Cell[6400, 206, 223, 8, 31, "Input"],
Cell[6626, 216, 171, 5, 29, "Text",
 Evaluatable->False],
Cell[6800, 223, 930, 26, 52, "Input"],
Cell[7733, 251, 1155, 43, 86, "Text",
 Evaluatable->False],
Cell[8891, 296, 297, 9, 31, "Input"],
Cell[9191, 307, 89, 2, 29, "Text",
 Evaluatable->False],
Cell[9283, 311, 194, 5, 31, "Input"],
Cell[9480, 318, 99, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[9604, 324, 115, 3, 36, "Subsection",
 Evaluatable->False,
 PageBreakAbove->True],
Cell[9722, 329, 137, 4, 29, "Text",
 Evaluatable->False],
Cell[9862, 335, 3215, 105, 272, "Input"],
Cell[13080, 442, 1481, 44, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14598, 491, 150, 5, 36, "Subsection",
 Evaluatable->False,
 PageBreakAbove->True],
Cell[14751, 498, 158, 5, 29, "Text",
 Evaluatable->False],
Cell[14912, 505, 6505, 213, 452, "Input"],
Cell[21420, 720, 1498, 44, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22955, 769, 54, 0, 36, "Subsection"],
Cell[23012, 771, 7065, 230, 412, "Input"],
Cell[30080, 1003, 1534, 45, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31651, 1053, 73, 2, 71, "Section",
 Evaluatable->False],
Cell[31727, 1057, 1384, 37, 177, "Text",
 Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

